package gov.va.vinci.dart.json.builder;

import java.util.ArrayList;
import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.json.DocumentTemplateListView;
import gov.va.vinci.dart.json.DocumentTemplateView;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestDocumentTemplateListViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		DocumentTemplateListViewBuilder builder = new DocumentTemplateListViewBuilder();
		
		try {
			builder.build(null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}
		
		List<DocumentTemplate> templateList = new ArrayList<DocumentTemplate>();
		
		DocumentTemplateListView dtlv = builder.build(templateList);
		Assert.assertNotNull(dtlv);
		Assert.assertNotNull(dtlv.getTemplates());
		Assert.assertEquals(dtlv.getTemplates().size(), 0);
		
		DocumentTemplate dt = DartObjectFactory.getInstance().getDocumentTemplateDAO().findById(4);
		templateList.add(dt);
		
		dtlv = builder.build(templateList);
		Assert.assertNotNull(dtlv);
		Assert.assertNotNull(dtlv.getTemplates());
		Assert.assertEquals(dtlv.getTemplates().size(), 1);
		Assert.assertTrue(dtlv.getTemplates().get(0) instanceof DocumentTemplateView);
		
		DocumentTemplateView dtv = (DocumentTemplateView)dtlv.getTemplates().get(0);
		Assert.assertNotNull(dtv);
		Assert.assertEquals(dtv.getId(), 4);
	}
}
